#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main() {
    int n;
    
    // 1. ???? ????? ????????
    if (scanf("%d", &n) != 1) return 1;

    if (n > 300000 || n < 1) {
        return 1;
    }
    
    // ????????? malloc ?? ?????? ?????? ?????? VLA (Variable Length Array)
    // ??? ???? ???????? ??????????? ?????
    int (*pozicije)[2] = malloc(n * sizeof(*pozicije));
    if (pozicije == NULL) return 1;

    for (int i = 0; i < n; i++) {
        if (scanf("%d %d", &pozicije[i][0], &pozicije[i][1]) != 2) {
            free(pozicije);
            return 1;
        }
    }

    // 2. ???????? ?????? ?????? ???????????? ????????
    double max_distance = -1.0;
    
    // ??? ?? ?????? ??????? ???????? ?????????? ??????
    // ??????? ?? ?? ??? N ?????????, ? ???????? ??????? ??? ????? ???? ??????
    int *pozmax = malloc(n * sizeof(int));
    if (pozmax == NULL) {
        free(pozicije);
        return 1;
    }
    int k = 0; // ?????? ????????? ? ???? pozmax

    // 3. ??????????? ?????????? ?????? ? ???? ????????????? ???????
    for (int i = 0; i < n; i++) {
        // ????????? ?????????? ?? ???????? ???????? ??????????
        double current_distance = hypot((double)pozicije[i][0], (double)pozicije[i][1]);

        if (current_distance > max_distance) {
            // ????? ??? ???? ????????
            max_distance = current_distance;
            
            // ?????????? ????? ? ???????? ???? ??????
            k = 0; 
            pozmax[k++] = i + 1; // ????????? 1-???????? ???????????
        }
        // ???? ???????? ?? ????????????? ??? ???????? ??????? ?? ????????? ???????, 
        // ????????? ??????????? (EPSILON)
        else if (fabs(current_distance - max_distance) < 1e-9) { 
            // ?????? ?? ???? ??? ???????? ????????
            pozmax[k++] = i + 1; // ????????? 1-???????? ???????????
        }
    }

    // 4. ???????? ????????
    printf("%d\n", k); // ???????? k, ? ?? index

    for (int i = 0; i < k; i++) {
        printf("%d%c", pozmax[i], (i == k - 1) ? '\n' : ' ');
    }
    
    // ?????????? ????????
    free(pozicije);
    free(pozmax);

    return 0;
}